<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<HTML>
   <HEAD>
      <META HTTP-EQUIV="Pragma" CONTENT="no cache ">
      <META NAME="Organization" CONTENT="The Scripps Research Institute">
      <META NAME="Copyright" CONTENT="The Scripps Research Institute">
      <META NAME="Version" CONTENT="1">
      <META NAME="Author" CONTENT="Jesus M. Castagnetto, jesusmc@scripps.edu">
      <META NAME="Keywords" CONTENT="metal,protein,metalloprotein,protein
                                     design,structure,database,molecular
                                     biology,metalloenzyme,metalloantibody,
                                     database,query,java">
      <META NAME="Description" CONTENT="A structural database of metal-binding
                                        sites in metalloproteins, including an
                                        interactive search and visualization
                                        interface.">
      <TITLE>
         MDB (Query Results) - Metalloprotein Site Database and Browser
      </TITLE>
      <SCRIPT TYPE="text/javascript" LANGUAGE="JavaScript"
              SRC="/javascript/mainbar.js">
      </SCRIPT>
   </HEAD>
   <BODY BGCOLOR="#FFFFFF">
      <TABLE BORDER=0 CELLSPACING=0 WIDTH="100%">
         <TR> 
            <TD COLSPAN=2>
               <?php virtual ("/include/navhead.inc") ?>
            </TD>
         </TR>
         <TR VALIGN="top">
            <TD BGCOLOR="#06F6FA" ROWSPAN=2>
               <?php virtual ("/include/navside.inc") ?>
            </TD>
            <TD><HR>
               <?php virtual ("/include/logo.inc") ?>
               <!-- END of MDB Logo -->
               <HR>
               <H2 ALIGN="CENTER">
                  Results of querying the MDB using PDB ID(s)
               </H2>
               <?php
                  /* 
                   * Script: pdbsearch.php
                   * Written by: Jesus M. Castagnetto
                   * For the MDB site
                   * 
                   * Based on the "remote.php" script.
                   *
                   * Created: Fri Jan 29 14:26:14 PST 1999
                   */
                  /* included scripts are in the /php_inc/ dir */
                  require ("sql.inc");

                  /* Include the function to generate tables from results */
                  require ("tables.inc");
                  require ("parseinput.inc");
                  /* Initialization of variables */
                  $db = "metallodb";
                  $querylog = "tmp/pdb_id_advqueries.log";
                  /*    
                   * Main section of the script
                   * 
                   * This script assumes that the database server is on the same
                   * machine as the web server that invokes it. 
                   */
    
                  /* Get a connection and select the database */
                  $link = SQL_pconnect ();
                  // $link = SQL_connect (); # If you prefer a simple connection

                  if ( !$link ) {
                     echo("<TABLE BORDER=5><TR BGCOLOR=\"yellow\"><TD>");
                     echo("Error connecting to the server\n");
                     echo(SQL_error() . "\n");
                     echo("</TD></TR></TABLE>");
                     echo("</CENTER></BODY></HTML>");
                     exit;
                  }

                  if (!SQL_select_db($db,$link)) {
                     echo("<TABLE BORDER=5><TR BGCOLOR=\"yellow\"><TD>");
                     echo("Error selecting database " . $db);
                     echo(SQL_error() . "\n");
                     echo("</TD></TR></TABLE>");
                     echo("</CENTER></BODY></HTML>");
                     exit;
                  }
                  /* pdb ids requested */
                  if ($pdbids) {
                     $q_pdbids = parseList("site.source_id = ", 
                                           strtolower($pdbids));
                  } else {
                     echo("<TABLE BORDER=5><TR BGCOLOR=\"yellow\"><TD>");
                     echo ("<B>Error</B> PDB id(s) needed for the search</B>");
                     echo("</TD></TR></TABLE>");
                     echo("</CENTER></BODY></HTML>");
                     exit;
                  }
                  /* construct and submit the search */
                  $query = "SELECT distinct site.source_id, site.site_id,
                            site.num_ligands, site.metal, protein.description";
                  $query .= " FROM protein, site WHERE ";
                  $query .= $q_pdbids;
                  $query .= " AND protein.source_id=site.source_id ORDER BY
                             site.site_id";
                  $query = strtolower(stripslashes($query));
                  /* save to a file for debugging */
                  $datestamp = date("Y-m-d#H:m:s#", time());
                  $dbgfp = fopen ($querylog, "a");
                  $ip = getenv("REMOTE_ADDR");
                  $agent = getenv("HTTP_USER_AGENT") . " || " .
                           getenv("HTTP_REFERER");
                  fwrite ($dbgfp, "$datestamp");
                  fwrite ($dbgfp, "$ip#$agent#");
                  fwrite ($dbgfp, "$query");
                  /* Get the results and process */
                  $result = SQL_query($query,$link);
                  if (!$result) {
                     echo("<TABLE BORDER=5><TR BGCOLOR=\"yellow\"><TD>");
                     echo("Error obtaining the query results\n");
                     echo(SQL_error() . "\n");
                     echo("</TD></TR></TABLE>");
                     echo("</CENTER></BODY></HTML>");
                     exit;
                  }
                  $nrows = SQL_num_rows($result);

                  /* create hits table only if we got some results */
                  if ($nrows > 0) {
                     echo("<DIV ALIGN=\"CENTER\"><B>
                              You searched for PDB ID(s):");
                     echo("</B>".$pdbids."<BR>And ".$nrows);
                     echo(" ".($nrows>1?"sites were":"site was")." found");
                     makeTable($result,100000);
                  } else {
                     echo ("<DIV ALIGN=\"CENTER\" STYLE=\"background: yellow;\">
                            <BIG>No sites were found that matched your query
                            </BIG></DIV>");
                  }
                  fwrite ($dbgfp, sprintf("#%d\n", $nrows));
                  fclose($dbgfp);
                  if ($result) SQL_free_result($result);
               ?>
            </TD>
         </TR>
         <TR>
            <TD ALIGN="CENTER" BGCOLOR="#E0FFFF">
               <HR WIDTH="50%">
               <?php virtual ("/include/nav_mdb_text.inc") ?>
               <HR WIDTH="50%">
            </TD>
         </TR>
         <TR>
            <TD colspan=2 bgcolor="#06F6FA" ALIGN="CENTER">
               <?php virtual ("/include/navfoot.inc") ?>
            </TD>
         </TR>
      </TABLE><HR>
      <ADDRESS>
         <SMALL>
            Page maintained by Jesus M.
            Castagnetto (jesusmc@scripps.edu) -
            &copy; The Scripps Research Institute. <BR>
            Query performed on: <?php echo (date("D, F d, Y - h:i a", 
                                                 time())); ?>
         </SMALL>
      </ADDRESS>
   </BODY>
</HTML>
